#include <windows.h>
#include <commdlg.h>
#include "Resource.h"
#include "Editor.h"
#include "Externs.h"

/* GLOBALS */
HWND  g_hWnd;
char *g_AppPath;
OPENFILENAME g_Ofn;
/***********/

static int InitAppWindow(HINSTANCE hInst, int iCmdShow, PSTR CmdLine);
static long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

static bool bFocus, bNeedPaint, bAllReady;

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, PSTR szCmd, int iCmdShow)
{
   MSG   msg;

   if (InitAppWindow(hInst, iCmdShow, szCmd))
   {
      MessageBox(NULL, "Error initializing program window.", "Error!", MB_OK);
      return 1;
   }

   ZeroMemory(&g_Ofn, sizeof(g_Ofn));
   g_Ofn.lStructSize  = sizeof(g_Ofn);
   g_Ofn.hwndOwner    = g_hWnd;
   g_Ofn.lpstrFilter  = "Data Files (*.dat)\0*.dat\0";
   g_Ofn.nFilterIndex = 1;
   g_Ofn.nMaxFile     = 255;

   if (LoadObjects())  return 2;
   if (InitGraphics()) return 3;

   bAllReady = true;
   ChooseObject(0);

   while(GetMessage(&msg, NULL, 0, 0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
} /* WinMain */


int InitAppWindow(HINSTANCE hInst, int iCmdShow, PSTR CmdLine)
{
   static char AppClass[] = "rItemEdit";
   HWND        hwnd;
   WNDCLASSEX  wndclass;

   wndclass.cbSize        = sizeof(wndclass);
   wndclass.style         = CS_HREDRAW | CS_VREDRAW;
   wndclass.lpfnWndProc   = WindowProc;
   wndclass.cbClsExtra    = 0;
   wndclass.cbWndExtra    = DLGWINDOWEXTRA; 
   wndclass.hInstance     = hInst;
   wndclass.hIcon         = LoadIcon  (NULL, IDI_APPLICATION);
   wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wndclass.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
   wndclass.lpszMenuName  = NULL;
   wndclass.lpszClassName = AppClass;
   wndclass.hIconSm       = LoadIcon  (NULL, IDI_APPLICATION);
   
   RegisterClassEx(&wndclass);

   hwnd = CreateDialog(hInst, AppClass, 0, NULL);
   if (!hwnd) return 1;
   g_hWnd = hwnd;
   SendMessage(hwnd, WM_INITDIALOG, 0, 0);   // for some reason this isnt being sent

   ShowWindow(hwnd, iCmdShow);
   return 0;
} /* InitAppWindow */


long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
   switch(iMsg)
   {
      case WM_COMMAND:
         switch(LOWORD(wParam))
         {
            case IDL_ATTR:
               switch(HIWORD(wParam))
               {
                  case LBN_SELCHANGE:
                     ChangeAttr((int)SendMessage((HWND)lParam, LB_GETCURSEL, 0, 0));
                     break;
               }
               break;

            case IDC_OBJCOMBO:
               switch(HIWORD(wParam))
               {
                  case CBN_SELCHANGE:
                     ChooseObject((int)SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0));
                     break;
               }
               break;

            case IDC_ITEMCOMBO:
               switch(HIWORD(wParam))
               {
                  case CBN_SELCHANGE:
                     ChooseItem((int)SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0));
                     break;
               }
               break;

            case IDE_ENUMNAME:
               switch(HIWORD(wParam))
               {
                  case EN_KILLFOCUS:
                     UpdateItemBox();
                     break;
               }
               break;

            case IDB_NEW:
               NewItem();
               break;

            case IDB_DELETE:
               DelItem();
               break;

            case IDB_SAVE:
               SaveItems();
               break;

            case IDB_LOAD:
               LoadItems();
               break;

            case IDB_REDRAW:
               if(bAllReady) RedrawObject();
               break;
         }
         return 0;

      case WM_PAINT:
         if (!bFocus) bNeedPaint = true;
         else if (bAllReady && RedrawObject())
            MessageBox(g_hWnd, "Error drawing object", "Error!", MB_OK);
         break;

      case WM_ACTIVATE:
         // Pause if deactivated
         bFocus = !(LOWORD(wParam) == WA_INACTIVE);
         if (bNeedPaint) InvalidateRect(g_hWnd, NULL, FALSE);
         return 0;

      case WM_SIZE:
      case WM_MOVE:
         UpdateCoords();
         return 0;

      case WM_INITDIALOG:
         {
            char *AttrList[]  = { "Str", "Int", "Dex", "Spd", "Def", "Attk", "Hits" };
            char *TypeList[]  = { "IT_WEAPON", "IT_SCROLL", "IT_POTION", "IT_ARMOR" };
            char *EquipList[] = { "EP_FINGER", "EP_HANDS", "EP_HEAD", "EP_NECK",
                                  "EP_TORSO",  "EP_ARMS",  "EP_FEET", "EP_WEAPON" };
            HWND hwndList  = GetDlgItem(hWnd, IDL_ATTR);
            HWND hwndType  = GetDlgItem(hWnd, IDC_TYPECOMBO);
            HWND hwndEquip = GetDlgItem(hWnd, IDC_EQUIPCOMBO);
            int i;
            for(i=0;i<NUMATTRS;   i++) SendMessage(hwndList,  LB_ADDSTRING, 0, (LPARAM) AttrList [i]); 
            for(i=0;i<ITEMTYPES;  i++) SendMessage(hwndType,  CB_ADDSTRING, 0, (LPARAM) TypeList [i]); 
            for(i=0;i<EQUIPPLACES;i++) SendMessage(hwndEquip, CB_ADDSTRING, 0, (LPARAM) EquipList[i]);
            SendMessage(hwndList,  LB_SETCURSEL, 0, 0);
            SendMessage(hwndType,  CB_SETCURSEL, 0, 0);
            SendMessage(hwndEquip, CB_SETCURSEL, 0, 0);
         }
         return 0;

      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }

   return DefWindowProc(hWnd, iMsg, wParam, lParam);
} /* WindowProc */
